/*
Copyright 2008-2009 Elöd Egyed-Zsigmond, Cyril Laitang
Copyright 2009-2011 Samuel Gesche

This file is part of IPRI News Analyzer.

IPRI News Analyzer is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

IPRI News Analyzer is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with IPRI News Analyzer.  If not, see <http://www.gnu.org/licenses/>.
*/

package data.structures.classification;

import java.util.Vector;
import java.util.Map;
import java.util.HashMap;

public class NuagePondere implements ClusterPart {
    private int id;
    private Vector<LemmePondere> lemmes = new Vector<LemmePondere>();
    private String titre;

    public NuagePondere(int id, String titre){
        this.id = id;
        this.titre = titre;
    }

    public String getTitre(){
        return titre;
    }

    public ClusterPart[] getSousClusters(){
        return new ClusterPart[]{};
    }

    public int getTotalClusters(){
        return 0;
    }

    public Map<String, String[]> aplanis(int nbClustersConserves){
        Map<String, String[]> res = new HashMap<String, String[]>();
        res.put(titre, new String[]{titre});
        return res;
    }

    public String[] getFeuilles() {
        return new String[]{titre};
    }

    public double getSimilarite(){
        return Double.MAX_VALUE;
    }

    public void addLemme(LemmePondere lemme){
        lemmes.add(lemme);
    }
    
    public LemmePondere[] getLemmes(String origine){
        Vector<LemmePondere> result = new Vector<LemmePondere>();
        for(int i=0; i<lemmes.size(); i++){
            if(lemmes.elementAt(i).getOrigine().equals(origine)){
                result.add(lemmes.elementAt(i));
            }
        }
        LemmePondere[] result2 = new LemmePondere[result.size()];
        result.toArray(result2);
        return result2;
    }

    public LemmePondere[] getAllLemmes(){
        LemmePondere[] result = new LemmePondere[lemmes.size()];
        lemmes.toArray(result);
        return result;
    }

    public Vector<LemmePondere> getAllLemmesAsVector(){
        return lemmes;
    }

    public int getId(){
        return id;
    }

    public void pondereOrigine(Operation origine, double poids){
        for(int i=0; i<lemmes.size(); i++){
            lemmes.elementAt(i).pondereOrigine(origine, poids);
        }
    }

    public void pondereCategorie(String categorie, double poids){
        for(int i=0; i<lemmes.size(); i++){
            if (lemmes.elementAt(i).getCategorie() != null) {
                if (lemmes.elementAt(i).getCategorie().equals(categorie)) {
                    lemmes.elementAt(i).pondereCategorie(poids);
                }
            }
        }
    }

    public void pondereAllCategories(double poids){
        for(int i=0; i<lemmes.size(); i++){
            if(lemmes.elementAt(i).getCategorie()!=null){
                lemmes.elementAt(i).pondereCategorie(poids);
            }
        }
    }

    public void pondereTaille(){
        for(int i=0; i<lemmes.size(); i++){
            lemmes.elementAt(i).pondereTaille(lemmes.size());
        }
    }

    public String toString(){
        return ">"+getTitre();
    }
}
